using System;
using System.Web;
using System.Xml;
using System.Text;
using System.Data;
using System.Data.OleDb;
using System.Web.UI;
using System.Reflection;
using System.Data.SqlClient;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public class PectraOBPI {
  //-
  private object m_oObpi;
  private Assembly oAssembly;
  //-
  #region [ - Main members -]
  public PectraOBPI() {
	oAssembly = Assembly.LoadWithPartialName("PectraOBPINET"); 
    m_oObpi = oAssembly.CreateInstance("PectraOBPINET.Engine");
  }
  ~PectraOBPI() {
	oAssembly = null;
    m_oObpi = null;
    GC.Collect();
  }
  #endregion
  //-
  public void ActivityEnd(long plTrxId, string pszAttributes) {
    m_oObpi.GetType().InvokeMember("ActivityEnd", BindingFlags.InvokeMethod, null, m_oObpi,
      new object[] { plTrxId, pszAttributes }
    );
  }
  public void PackageDelOne(long plTrxId) {
    m_oObpi.GetType().InvokeMember("PackageDelOne", BindingFlags.InvokeMethod, null, m_oObpi,
      new object[] { plTrxId }
    );
  }
  public void InstanceLockUnLock(long plTrxId, bool pbLock) {
    m_oObpi.GetType().InvokeMember("InstanceLockUnLock", BindingFlags.InvokeMethod, null, m_oObpi,
      new object[] { plTrxId, pbLock }
    );
  }
  public string AttributeGetValue(long plTrxId, string pszAtrId) {
    return
      m_oObpi.GetType().InvokeMember("AttributeGetValue", BindingFlags.InvokeMethod, null, m_oObpi,
        new object[] { plTrxId, pszAtrId }
      ).ToString();
  }
  public string AttributeSetValue(string pszAtrId, string pszAtrValue, string pszSetAttributes) {
    return
      m_oObpi.GetType().InvokeMember("AttributeSetValue", BindingFlags.InvokeMethod, null, m_oObpi,
        new object[] { pszAtrId, pszAtrValue, pszSetAttributes }
      ).ToString();
  }
  public string AttributeSetValue(string pszAtrId, string pszAtrValue, string pszSetAttributes, byte[] poExtendedValue, string pszContentType) {
    return
      m_oObpi.GetType().InvokeMember("AttributeSetValue", BindingFlags.InvokeMethod, null, m_oObpi,
        new object[] { pszAtrId, pszAtrValue, pszSetAttributes, poExtendedValue, pszContentType }
      ).ToString();
  }
  public byte[] AttributeGetValueExtended(params object[] paoParams) {
    return (byte[])m_oObpi.GetType().InvokeMember(
      "AttributeGetValueExtended", BindingFlags.InvokeMethod,
      null, m_oObpi, paoParams
    );
  }
}

public partial class CSASPXForm : System.Web.UI.Page {

  //- Generated by PECTRA CnnManager - 2007
  //- ---------------------------------------------------------
  //- Page Date    : @<FormAttributes>PageDate</FormAttributes>
  //- Page Version : @<FormAttributes>Version</FormAttributes>

  #region [ - Public Members - ]
  public bool blnPreview;
  public PectraOBPI objPectraObpi;
  public string strFolderUpload;
  public string sLastName = string.Empty, sFirstsName = string.Empty;
  public long lngTrxId, lngInsId, lngTrxIdOrigen;
  #endregion
  #region [ - Private Members - ]
  private string strErrDescription;
  private object oUsrInt, oNodeUsr;
  private XmlDocument oDomNode;
  private bool blnActivityInitial;
  private bool blnShowError;
  #endregion
  #region [ - DataSource and Attributes Declarations - ]
  //---------------------------------------------------------------
  //DataSources
  //---------------------------------------------------------------
  //@<FormDataSources>Declare</FormDataSources>

  //---------------------------------------------------------------
  // Form Attributes
  //---------------------------------------------------------------
  //@<FormAttributes>Declare</FormAttributes>
  #endregion

  #region [ - Custom Functions and Procedures - ]
  //@<FormScript>SourceCode</FormScript>
  #endregion

  private void InitializeValues() {
    //-
    try {
      if (Request.QueryString["InsId"] != null)
        lngInsId = int.Parse(Request.QueryString["InsId"]);
      else
        lngInsId = 0;
      if (Request.QueryString["TrxId"] != null)
        lngTrxId = int.Parse(Request.QueryString["TrxId"]);
      else
        lngTrxId = 0;
      //-
      //- Consulto si es la actividad inicial o no
      if (objPectraObpi.AttributeGetValue(lngTrxId, "ActId") == "1") {
        blnActivityInitial = true;
      } else {
        blnActivityInitial = false;
      }
      //-
      if (blnActivityInitial == true) {
        //es un nombre aleatorio, de forma que sea nico (debido a que no existe en este momento un PngInsId
        strFolderUpload = lngTrxId.ToString();
      } else {
        //se le asigna el PngInsId a la carpeta en que se guardan los archivos
        strFolderUpload = objPectraObpi.AttributeGetValue(lngTrxId, "PngInsId");
      }
      //-
      lngTrxIdOrigen = int.Parse(Request.QueryString["TrxIdOrigen"]);
      //-
      blnPreview = true;
      if (Request.QueryString["Preview"] == "1") blnPreview = false;
      //-
      //- Si se est previsualizando...
      if (blnPreview) {
        //- Capturo el usuario logueado
        oUsrInt = Activator.CreateInstance(Type.GetTypeFromProgID("UsrInterface.Engine"));
        oNodeUsr = oUsrInt.GetType().InvokeMember("GetOneUsrNode", BindingFlags.InvokeMethod, null, oUsrInt,
          new object[] { objPectraObpi.AttributeGetValue(lngTrxId, "LoguedUsrId") }
        );
        oDomNode = new XmlDocument();
        oDomNode.LoadXml(oNodeUsr.GetType().InvokeMember("xml", BindingFlags.GetProperty, null, oNodeUsr, null).ToString());
        sFirstsName = oDomNode.SelectSingleNode("//FirstName").InnerText;
        sLastName = oDomNode.SelectSingleNode("//LastName").InnerText;
        //-
        oDomNode = null;
        oNodeUsr = null;
        oUsrInt = null;
      }
      //-
      //- Inicio los dataSources, si es que se definieron
      if (!IsPostBack) {
        try {
          MethodInfo[] oMethods = this.GetType().GetMethods();
          foreach (MethodInfo oMethod in oMethods) {
            if (oMethod.Name.StartsWith("InitializeDataSources") ||
                oMethod.Name.StartsWith("InitializeCOMDataSources") ||
                oMethod.Name.StartsWith("InitializeWSDataSources"))
              oMethod.Invoke(this, null);
          }
          oMethods = null;
        } catch { }
      }
      //-
    } catch {
      //- Do Nothing
    }
  }
  private void InitializeAttributes() {
    //@<FormAttributes>PreProcess</FormAttributes>
  }

  private string EstandarizarXmlDb(DataTable oDT) {
    int i;
    string strDataFieldContent, strXmlFillDb;
    strDataFieldContent = strXmlFillDb = "";

    if (oDT != null) {
      foreach (DataRow oRow in oDT.Rows) {
        foreach (DataColumn oCol in oDT.Columns) {
          strDataFieldContent += "<" + oCol.ColumnName.Trim() + "><![CDATA[" +
            oRow[oCol.ColumnName].ToString().Trim() + "]]></" + oCol.ColumnName.Trim() + ">";
        }
        strXmlFillDb += "<DataField>" + strDataFieldContent + "</DataField>";
        strDataFieldContent = "";
      }
      return "<Data>" + strXmlFillDb + "</Data>";
    }
    //-
    return "<Data />";
  }
  private string EstandarizarXmlWs(XmlDocument oXml) {
    XmlNode oNodo;
    string strNodeName, strDatos;
    string strXmlFillWs;

    try {
      oNodo = oXml.DocumentElement.FirstChild;
      strNodeName = strDatos = strXmlFillWs = "";
      strNodeName = oNodo.Name;
      //-
      foreach (XmlNode oChild in oXml.SelectNodes("//" + strNodeName)) {
        foreach (XmlNode oLastNode in oChild.ChildNodes) {
          strDatos += "<" + oLastNode.Name + "><![CDATA[" +
            oLastNode.InnerText + "]]></" + oLastNode.Name + ">";
        }
        strXmlFillWs += "<DataField>" + strDatos + "</DataField>";
        strDatos = "";
      }
      //-
      return "<Data>" + strXmlFillWs + "</Data>";
    } catch (Exception ex) {
      this.PrepareErrLog(ex);
      return "<Data />";
    } finally {
      oNodo = null;
    }
  }
  
  protected void FillCombo(DataTable oDataTable, string szDataSourceField)
  {
	if (oDataTable != null)
	{
		string szValue;
		
		foreach (DataRow oRow in oDataTable.Rows)
		{
			szValue = oRow[szDataSourceField].ToString();
			Response.Write("<option value=\"" + szValue + "\">" + szValue + "</option>");
		}
	}		
  }

  public bool IsDate(object inValue) {
    DateTime tmpDT;
    try {
      tmpDT = DateTime.Parse(inValue.ToString());
      return true;
    } catch (NullReferenceException) {
      return false;
    } catch (FormatException) {
      return false;
    } finally {
      GC.Collect();
    }
  }
  public string Day(object inValue) {
    if (IsDate(inValue)) {
      return DateTime.Parse(inValue.ToString()).Day.ToString();
    } else
      return DateTime.Now.Day.ToString();
  }
  public string Month(object inValue) {
    if (IsDate(inValue)) {
      return DateTime.Parse(inValue.ToString()).Month.ToString();
    } else
      return DateTime.Now.Month.ToString();
  }
  public string Year(object inValue) {
    if (IsDate(inValue)) {
      return DateTime.Parse(inValue.ToString()).Year.ToString();
    } else
      return DateTime.Now.Year.ToString();
  }

  private void PrepareErrLog(Exception ex) {
    strErrDescription = "<span class=\"font-family: Courier New; font-size: 10px;\">" +
                        "Description : " + ex.Message + "<br />" +
                        "StackTrace  : " + ex.StackTrace + "</span>";
    //-
    this.ShowConfirmMessage(strErrDescription);
  }
  private void ShowConfirmMessage(string pszMessage) {
    HtmlTableRow oNewRow;
    HtmlTableCell oNewCel;

    try {
      tblButtons.Rows.Clear();
      tblContent.Rows.Clear();
      //-
      //- Preparo los botones
      oNewRow = new HtmlTableRow();
      oNewRow.Attributes.Add("class", "Line");
      oNewRow.Cells.Add(new HtmlTableCell());
      oNewRow.Cells.Add(new HtmlTableCell());
      tblButtons.Rows.Add(oNewRow);
      //-
      //- Preparo el mensaje
      oNewRow = new HtmlTableRow();
      oNewRow.Attributes.Add("class", "Line");
      for (int i = 0; i < 2; i++) {
        oNewCel = new HtmlTableCell();
        oNewCel.Attributes.Add("class", "Value");
        if (i == 1) {
          oNewCel.Attributes.Add("align", "left");
          oNewCel.InnerHtml = pszMessage;
        } else {
          oNewCel.InnerHtml = "&nbsp;";
        }
        oNewRow.Cells.Add(oNewCel);
      }
      tblContent.Rows.Add(oNewRow);
      //-
    } catch (Exception ex) {
      this.blnShowError = true;
      this.PrepareErrLog(ex);
    } finally {
      oNewCel = null;
      oNewRow = null;
      GC.Collect();
    }
  }

  protected void Page_Load(object sender, EventArgs e) {
    this.blnShowError = false;
    try {
      //- Instancia la clase "Engine" del assembly "PectraOBPINET"
	  objPectraObpi = new PectraOBPI();
      //-
      this.InitializeValues();
      if (!IsPostBack) this.InitializeAttributes();
      //-
    } catch (Exception ex) {
      this.blnShowError = true;
      this.PrepareErrLog(ex);
    } finally {
      GC.Collect();
    }
  }

  protected void btnOk_Click(object sender, EventArgs e) {
    string strSetAttributes = string.Empty;
    // ================================================
    //     OK
    // ================================================
    try {
      // Set Attributes
      //@<FormAttributes>GetData</FormAttributes>

      // Set DataDestinations
      //@<FormDataDestinations>GetData</FormDataDestinations>

      // Activity End
      objPectraObpi.ActivityEnd(lngTrxId, strSetAttributes);
      //-
      //- Ahora muestro el mensaje de confirmacin
      this.ShowConfirmMessage("Transaction Processed.");
    } catch (Exception ex) {
      this.blnShowError = true;
      this.PrepareErrLog(ex);
    } finally {
      GC.Collect();
    }
  }
  protected void btnCancel_Click(object sender, EventArgs e) {
    // ================================================
    //     CANCEL
    // ================================================
    try {
      // Unlock Instance
      objPectraObpi.InstanceLockUnLock(lngTrxId, false);
      // Clean Pkg
      objPectraObpi.PackageDelOne(lngTrxId);
      //-
      //- Ahora muestro el mensaje de confirmacin
      if (!blnShowError)
        this.ShowConfirmMessage("Transaction Processed.");
    } catch (Exception ex) {
      this.blnShowError = true;
      this.PrepareErrLog(ex);
    } finally {
      GC.Collect();
    }
    //-
  }

}
